CONTAINER fx_shader_gas
{
	NAME fx_shader_gas;
	INCLUDE Mpreview;
	INCLUDE Mbase;

	GROUP Obaselist
	{
		BOOL DPIT_MG_PRESETS		{PAGE; HIDDEN;PARENTMSG GASSHADER_PRESETS_G;}
		BOOL DPIT_MG_GENERAL		{PAGE; HIDDEN;PARENTMSG GASSHADER_GENERAL_G;}
		BOOL DPIT_MG_SMOKE		{PAGE; HIDDEN;PARENTMSG GASSHADER_SMOKE_G;}
		BOOL DPIT_MG_FIRE		{PAGE; HIDDEN;PARENTMSG GASSHADER_FIRE_G;}
		BOOL DPIT_MG_COMPOSITE		{PAGE; HIDDEN;PARENTMSG GASSHADER_COMPOSITE_G;}			
	}
	GROUP GASSHADER_PRESETS_G
	{
		LONG GASSHADER_PRESETS
		{
			CYCLE
			{
				GASSHADER_PRESET_DEFAULT;
			}
		}
		GROUP
		{
		COLUMNS 4;
		BUTTON GASSHADER_PRESETS_SET {}
		BUTTON GASSHADER_PRESETS_SAVE {}
		BUTTON GASSHADER_PRESETS_SAVEAS {}
		BUTTON GASSHADER_PRESETS_DE {}
		}
	}	
	GROUP GASSHADER_GENERAL_G
	{
		DEFAULT 1;

		REAL  GASSHADER_UPSAMPLING_VOXELSCALE { MIN 0.5; STEP 0.1; MAX 5.0;}
		BOOL  GASSHADER_UPSAMPLING_NOPREVIEW {PARENTID GASSHADER_UPSAMPLING_VOXELSCALE;}
		LONG  GASSHADER_UPSAMPLING_INTERPOLATION
		{
			CYCLE 
			{ 
				GASSHADER_UPSAMPLING_INTERPOLATION_LINEAR;
				GASSHADER_UPSAMPLING_INTERPOLATION_CUBIC;
				GASSHADER_UPSAMPLING_INTERPOLATION_HERMITE;
			}
			PARENTID GASSHADER_UPSAMPLING_VOXELSCALE;
		}
		
		SEPARATOR {LINE;}

		REAL  GASSHADER_RAY_JITTER {MIN 0; MAX 100; UNIT PERCENT;}
		REAL  GASSHADER_STEPMIN {MIN 0.01; MAX 10000; STEP 0.1; UNIT METER;}
		REAL  GASSHADER_STEPMAX {MIN 0.01; MAX 10000; STEP 0.1; UNIT METER;}
		LONG  GASSHADER_RENDER_INTERPOLATION 
		{
			CYCLE 
			{ 
				GASSHADER_RENDER_INTERPOLATION_LINEAR;
				GASSHADER_RENDER_INTERPOLATION_COSINE;
				GASSHADER_RENDER_INTERPOLATION_CUBIC;
			}
		}			
		BOOL  GASSHADER_EARLYRAYTERMINATION {HIDDEN;}
		BOOL  GASSHADER_TRAPEZOIDAL {}

		SEPARATOR {LINE;}
			
		IN_EXCLUDE GASSHADER_LIGHTLIST
		{
			NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 1;
			ACCEPT { Olight; };
		}
	}
	GROUP GASSHADER_SMOKE_G
	{
		GROUP
		{
			COLUMNS 2;
			LINK GASSHADER_SMOKE_DENSITY { ACCEPT{fx_channel_scalar; fx_channel_temp;fx_channel_fuel; fx_channel_fire;} }
			BUTTON  GASSHADER_SMOKE_DENSITY_SELECTOR {SCALE_V; FIT_H;}
			
			LINK GASSHADER_SMOKE_FLUID { ACCEPT{fx_fluid;} }
			BUTTON  GASSHADER_SMOKE_FLUID_SELECTOR {SCALE_V; FIT_H;}
			
			REAL GASSHADER_SMOKE_ADVECTION { MIN 0.0; MAXSLIDER 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
		}
		GROUP GASSHADER_SMOKE_COLOR_SUB
		{
			DEFAULT 1;
			LINK	GASSHADER_SMOKE_COLOR { ACCEPT{fx_channel_vector;} }			
			BOOL 	GASSHADER_SMOKE_COLOR_PRECOMPUTE {HIDDEN;}
			GRADIENT GASSHADER_SMOKE_COLOR_MAPPING {COLOR; ANIM ON; ICC_BASEDOCUMENT;}
		}

		GROUP GASSHADER_SMOKE_DENSITY_SUB
		{
			DEFAULT 1;	
			BOOL 	GASSHADER_SMOKE_DENSITY_PRECOMPUTE {HIDDEN;}
			REAL	GASSHADER_SMOKE_DENSITY_MULTIPLIER {MIN 0.001; UNIT PERCENT;}
			GRADIENT GASSHADER_SMOKE_DENSITY_MAPPING {ALPHA; ANIM ON;}
			IN_EXCLUDE GASSHADER_SMOKE_DENSITY_CONSTRAINTS
			{
				NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 0;
				ACCEPT 
				{  
					fx_constraint_coffee; 
					fx_constraint_particledistance; 
					fx_constraint_particlecount;
					fx_constraint_volume; 
					fx_constraint_noise; 
					fx_constraint_gradient; 
					fx_constraint_gridvalue; 
					fx_constraint_gridaverage; 
					fx_constraint_voxeldistance; 
					fx_constraint_particle_collision;
					fx_constraint_particle_property;
				};
			}
			SEPARATOR {LINE;}

			GROUP
			{
				COLUMNS 2;
				LONG  GASSHADER_SMOKE_DENSITY_BLURITER {MIN 0; MAX 100;}
				REAL  GASSHADER_SMOKE_DENSITY_BLUR {MIN 0; MAX 1000; STEP 0.1;}			
			}

			SEPARATOR {LINE;}

			BOOL GASSHADER_SMOKE_DENSITY_NOISE {PARENTCOLLAPSE;FIT_H;}
			
			BITMAPBUTTON GASSHADER_SMOKE_DENSITY_NOISE_PREVIEW {BORDER;PARENTCOLLAPSE GASSHADER_SMOKE_DENSITY_NOISE; FIT_H;}
			
			GROUP
			{
				PARENTCOLLAPSE GASSHADER_SMOKE_DENSITY_NOISE;
				
				LONG GASSHADER_SMOKE_DENSITY_NOISE_SPACE
				{
					CYCLE
					{
						GASSHADER_SMOKE_DENSITY_NOISE_SPACE_WORLD;
						GASSHADER_SMOKE_DENSITY_NOISE_SPACE_PHYSICAL;
					}
				}
				LONG GASSHADER_SMOKE_DENSITY_NOISE_SEED { MIN 0; }
				LONG GASSHADER_SMOKE_DENSITY_NOISE_TYPE { CYCLE{} }
				REAL GASSHADER_SMOKE_DENSITY_NOISE_SCALE {MIN 0.0; UNIT PERCENT;}
				VECTOR GASSHADER_SMOKE_DENSITY_NOISE_SCALE3D {MIN 0 0 0; UNIT PERCENT;}
				REAL GASSHADER_SMOKE_DENSITY_NOISE_OCTAVES {MIN 0.0; MAX 50; }
				REAL GASSHADER_SMOKE_DENSITY_NOISE_ANIMATION {MIN 0.0; UNIT PERCENT;}
				LONG GASSHADER_SMOKE_DENSITY_NOISE_LOOP { MIN 0; }
				REAL GASSHADER_SMOKE_DENSITY_NOISE_DETAILATT {MIN 0.0; UNIT PERCENT;}
				REAL GASSHADER_SMOKE_DENSITY_NOISE_SAMPLINGDELTA {UNIT PERCENT;}
				BOOL GASSHADER_SMOKE_DENSITY_NOISE_ABSOLUTE {}

				SEPARATOR {LINE;}

				GRADIENT GASSHADER_SMOKE_DENSITY_NOISE_DENSITY {ALPHA; ANIM ON;}
				REAL GASSHADER_SMOKE_DENSITY_NOISE_LOWCLIP {MIN 0.0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
				REAL GASSHADER_SMOKE_DENSITY_NOISE_HIGHCLIP {MIN 0.0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
				REAL GASSHADER_SMOKE_DENSITY_NOISE_BRIGHTNESS {MIN -100.0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
				REAL GASSHADER_SMOKE_DENSITY_NOISE_CONTRAST {MIN 0.0; MAX 1000; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
			}
		}		
		GROUP GASSHADER_SMOKE_SCATTERING_G
		{	
			COLOR GASSHADER_SMOKE_OPTICAL_AMBIENT {}
			BOOL  GASSHADER_SMOKE_OCCLUSIONMAP_NOPREVIEW {}
			REAL  GASSHADER_SMOKE_OPTICAL_ABSORPTION {MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER; }				
			REAL  GASSHADER_SMOKE_OPTICAL_LUMINANCE {MIN 0; MAX 1000; MAXSLIDER 100;UNIT PERCENT;CUSTOMGUI REALSLIDER;}
				
			SEPARATOR {LINE;}

			LONG  GASSHADER_SMOKE_OPTICAL_PHASE
			{
				CYCLE
				{
					GASSHADER_SMOKE_OPTICAL_PHASE_NONE;
					GASSHADER_SMOKE_OPTICAL_PHASE_GREENSTEIN;
					GASSHADER_SMOKE_OPTICAL_PHASE_GREENSTEINNISHITA;
					GASSHADER_SMOKE_OPTICAL_PHASE_GREENSTEINDOUBLE;
					GASSHADER_SMOKE_OPTICAL_PHASE_RAYLEIGH;
					GASSHADER_SMOKE_OPTICAL_PHASE_MIE;
					GASSHADER_SMOKE_OPTICAL_PHASE_HAZY;
					GASSHADER_SMOKE_OPTICAL_PHASE_MURKY;
					GASSHADER_SMOKE_OPTICAL_PHASE_SCHLICK;
				}
			}
			REAL GASSHADER_SMOKE_OPTICAL_PHASE_ANISOTROPY	{MIN -100; MAX 100; UNIT PERCENT;CUSTOMGUI REALSLIDER;}
			REAL GASSHADER_SMOKE_OPTICAL_PHASE_ANISOTROPYTWO{MIN -100; MAX 100; UNIT PERCENT;CUSTOMGUI REALSLIDER;}
			REAL GASSHADER_SMOKE_OPTICAL_PHASE_INTENSITY	{MIN 0; MAX 1000; MAXSLIDER 100;UNIT PERCENT;CUSTOMGUI REALSLIDER;}	
			
			GROUP GASSHADER_SMOKE_OPTICAL_CONSTRAINTS
			{				 
				IN_EXCLUDE GASSHADER_SMOKE_OPTICAL_CONSTRAINTS_ABSORPTION
				{
					NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 0;
					ACCEPT {  fx_constraint_coffee; fx_constraint_particledistance; fx_constraint_particlecount;fx_constraint_volume; fx_constraint_noise; fx_constraint_gradient; fx_constraint_gridvalue; fx_constraint_gridaverage; fx_constraint_voxeldistance; fx_constraint_particle_collision;fx_constraint_particle_property;};
				}
				IN_EXCLUDE GASSHADER_SMOKE_OPTICAL_CONSTRAINTS_LUMINANCE
				{
					NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 0;
					ACCEPT {  fx_constraint_coffee; fx_constraint_particledistance; fx_constraint_particlecount;fx_constraint_volume; fx_constraint_noise; fx_constraint_gradient; fx_constraint_gridvalue; fx_constraint_gridaverage; fx_constraint_voxeldistance; fx_constraint_particle_collision;fx_constraint_particle_property;};
				}		 
				IN_EXCLUDE GASSHADER_SMOKE_OPTICAL_CONSTRAINTS_ANISOTROPY
				{
					NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 0;
					ACCEPT {  fx_constraint_coffee; fx_constraint_particledistance; fx_constraint_particlecount;fx_constraint_volume; fx_constraint_noise; fx_constraint_gradient; fx_constraint_gridvalue; fx_constraint_gridaverage; fx_constraint_voxeldistance; fx_constraint_particle_collision;fx_constraint_particle_property;};
				}		 
				IN_EXCLUDE GASSHADER_SMOKE_OPTICAL_CONSTRAINTS_INTENSITY
				{
					NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 0;
					ACCEPT {  fx_constraint_coffee; fx_constraint_particledistance; fx_constraint_particlecount;fx_constraint_volume; fx_constraint_noise; fx_constraint_gradient; fx_constraint_gridvalue; fx_constraint_gridaverage; fx_constraint_voxeldistance; fx_constraint_particle_collision;fx_constraint_particle_property;};
				}
			}
		}
		GROUP GASSHADER_SMOKE_MULTIPLESCATTERING_SUB
		{
			BOOL  GASSHADER_USEMS {}

			SEPARATOR {LINE;}

			BOOL  GASSHADER_MS_HOMOGEN {}
			REAL  GASSHADER_MS_MAPSIZE { MAX 1.; MIN 0.01; STEP 0.1; }

			//REAL  GASSHADER_MS_INTENSITY {MIN 0; MAX 10000; UNIT PERCENT;}
			REAL  GASSHADER_MS_DIFFUSION {MIN 1; MAX 1000; STEP 0.1;}
			REAL  GASSHADER_MS_MINCONTRIBUTION {MIN 0; MAX 100; STEP 0.001; UNIT PERCENT;}
				
			SEPARATOR {LINE;}
				
			BOOL  GASSHADER_MS_STEPSIZE_USEGENERAL {}
			REAL  GASSHADER_MS_STEPSIZE {MIN 0.01; MAX 1000; STEP 0.1; }
			REAL  GASSHADER_MS_SPACESCALE { MIN 0.01; MAX 100; UNIT PERCENT;}
				
			SEPARATOR {LINE;}

			BOOL  GASSHADER_MS_ABSORPTION_USEGENERAL {}
			REAL  GASSHADER_MS_ABSORPTION {MIN 0; MAX 10000; UNIT PERCENT; STEP 1;}

			SEPARATOR {LINE;}

			REAL  GASSHADER_MS_PHASE_ANISOTROPY	{MIN -100; MAX 100; UNIT PERCENT;}
			REAL  GASSHADER_MS_PHASE_INTENSITY	{MIN 0; MAX 1000; MAXSLIDER 100;UNIT PERCENT; CUSTOMGUI REALSLIDER;}
			
			SEPARATOR {LINE;}

			REAL  GASSHADER_MS_SCATTERING { MIN 0.001; MAX 6.0; STEP 0.01;}
			REAL  GASSHADER_MS_SCATTER_SCALE { MIN 0.01; MAX 100; UNIT PERCENT;}
			BOOL  GASSHADER_MS_MSA_AUTO {}
			REAL  GASSHADER_MS_MSA	{ MIN 0; MAX 100; UNIT PERCENT;}
			
			GROUP GASSHADER_SMOKE_MS_CONSTRAINTS
			{				 
				IN_EXCLUDE GASSHADER_SMOKE_MS_CONSTRAINTS_SCATTERING
				{
					NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 0;
					ACCEPT {  fx_constraint_coffee; fx_constraint_particledistance; fx_constraint_particlecount;fx_constraint_volume; fx_constraint_noise; fx_constraint_gradient; fx_constraint_gridvalue; fx_constraint_gridaverage; fx_constraint_voxeldistance; fx_constraint_particle_collision;fx_constraint_particle_property;};
				}		 
				IN_EXCLUDE GASSHADER_SMOKE_MS_CONSTRAINTS_SCATTERSCALE
				{
					NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 0;
					ACCEPT {  fx_constraint_coffee; fx_constraint_particledistance; fx_constraint_particlecount;fx_constraint_volume; fx_constraint_noise; fx_constraint_gradient; fx_constraint_gridvalue; fx_constraint_gridaverage; fx_constraint_voxeldistance; fx_constraint_particle_collision;fx_constraint_particle_property;};
				}		 
				IN_EXCLUDE GASSHADER_SMOKE_MS_CONSTRAINTS_ANISOTROPY
				{
					NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 0;
					ACCEPT {  fx_constraint_coffee; fx_constraint_particledistance; fx_constraint_particlecount;fx_constraint_volume; fx_constraint_noise; fx_constraint_gradient; fx_constraint_gridvalue; fx_constraint_gridaverage; fx_constraint_voxeldistance; fx_constraint_particle_collision;fx_constraint_particle_property;};
				}		 
				IN_EXCLUDE GASSHADER_SMOKE_MS_CONSTRAINTS_INTENSITY
				{
					NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 0;
					ACCEPT {  fx_constraint_coffee; fx_constraint_particledistance; fx_constraint_particlecount;fx_constraint_volume; fx_constraint_noise; fx_constraint_gradient; fx_constraint_gridvalue; fx_constraint_gridaverage; fx_constraint_voxeldistance; fx_constraint_particle_collision;fx_constraint_particle_property;};
				}
			}
		}
		GROUP GASSHADER_SMOKE_OCCLUSION_G
		{
			BOOL  GASSHADER_SMOKE_OCCLUSION_TRAPEZOIDAL {}
			REAL  GASSHADER_SMOKE_OCCLUSION_RAYJITTER {MIN 0; MAX 100; UNIT PERCENT;CUSTOMGUI REALSLIDER; }
			REAL  GASSHADER_SMOKE_OCCLUSION_STEPMIN {MIN 0.01; MAX 10000; STEP 0.1; UNIT METER;}
			REAL  GASSHADER_SMOKE_OCCLUSION_STEPMAX {MIN 0.01; MAX 10000; STEP 0.1; UNIT METER;}

			BOOL  GASSHADER_SMOKE_OCCLUSION_ARTISTIC {}
			COLOR GASSHADER_SMOKE_OCCLUSION_COLOR {}
			COLOR  GASSHADER_SMOKE_OCCLUSION_ABSORPTION_PREVIEW {  }	
			REAL  GASSHADER_SMOKE_OCCLUSION_ABSORPTION {MIN 0; MAX 1000; MAXSLIDER 100; UNIT PERCENT; CUSTOMGUI REALSLIDER; }	 
			IN_EXCLUDE GASSHADER_SMOKE_OCCLUSION_CONSTRAINTS
			{
				NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 0;
				ACCEPT {  fx_constraint_coffee; fx_constraint_particledistance; fx_constraint_particlecount;fx_constraint_volume; fx_constraint_noise; fx_constraint_gradient; fx_constraint_gridvalue; fx_constraint_gridaverage; fx_constraint_voxeldistance; fx_constraint_particle_collision;fx_constraint_particle_property;};
			}
			
			GROUP GASSHADER_SMOKE_OCCLUSIONMAP_SUB
			{
				REAL  GASSHADER_SMOKE_OCCLUSIONMAP_VOXELSCALE { MIN 0.1; STEP 0.1; }
				LONG  GASSHADER_SMOKE_OCCLUSIONMAP_EXTRAPOLATE {MIN 0; MAX 3;}

				SEPARATOR {LINE;}
				
				LONG  GASSHADER_SMOKE_OCCLUSIONMAP_BLURITER {MIN 0; MAX 100;}
				REAL  GASSHADER_SMOKE_OCCLUSIONMAP_BLUR {MIN 0; MAX 1000;}
				//REAL  GASSHADER_SMOKE_OCCLUSIONMAP_BLURBLENDMIX {MIN 0; MAX 1000; UNIT PERCENT;}
			}	
		}
		GROUP GASSHADER_SMOKE_SHADOWS_G
		{			
			BOOL GASSHADER_SMOKE_SHADOWS_RECEIVE {}
			REAL GASSHADER_SMOKE_SHADOWS_RECEIVE_DENSITY {MIN 0; UNIT PERCENT; }
			COLOR GASSHADER_SMOKE_SHADOWS_RECEIVE_DENSITY_COLOR {}
			
			SEPARATOR {LINE;}
			
			BOOL  GASSHADER_SMOKE_SHADOWS_CAST {}

			REAL  GASSHADER_SMOKE_SHADOWS_CAST_INTENSITY {MIN 0; MAX 500; UNIT PERCENT; PARENTID GASSHADER_SMOKE_SHADOWS_CAST;}
			REAL  GASSHADER_SMOKE_SHADOWS_RAYJITTER {MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER; PARENTID GASSHADER_SMOKE_SHADOWS_CAST;}
			REAL  GASSHADER_SMOKE_SHADOWS_STEPMIN {MIN 0.01; MAX 10000; STEP 0.1; UNIT METER;PARENTID GASSHADER_SMOKE_SHADOWS_CAST;}
			REAL  GASSHADER_SMOKE_SHADOWS_STEPMAX {MIN 0.01; MAX 10000; STEP 0.1; UNIT METER;PARENTID GASSHADER_SMOKE_SHADOWS_CAST;}
			COLOR GASSHADER_SMOKE_SHADOWS_COLOR {PARENTID GASSHADER_SMOKE_SHADOWS_CAST;}
		}
		GROUP GASSHADER_SMOKE_RENDER_SUB
		{
			DEFAULT 0;
			BOOL GASSHADER_SMOKE_RENDER_INVISIBLE {}
			BOOL GASSHADER_SMOKE_RENDER_GI {}
			BOOL GASSHADER_SMOKE_RENDER_TRANSPARENCY {}
			BOOL GASSHADER_SMOKE_RENDER_REFRACTION {}
			BOOL GASSHADER_SMOKE_RENDER_REFLECTION {}
			BOOL GASSHADER_SMOKE_RENDER_AO {}
		}
	}	
	GROUP GASSHADER_FIRE_G
	{				
		LONG  GASSHADER_FIRE_TYPE 
		{
			HIDDEN;
			CYCLE
			{
				GASSHADER_FIRE_TYPE_PHYSICAL;
				GASSHADER_FIRE_TYPE_ARTISTIC;
			}
		}

		GROUP
		{
			COLUMNS 2;
			LINK GASSHADER_FIRE_TEMPERATURE { ACCEPT{fx_channel_scalar; fx_channel_temp; fx_channel_fuel; fx_channel_fire;} }
			BUTTON  GASSHADER_FIRE_TEMPERATURE_SELECTOR {SCALE_V; FIT_H;}

			LINK GASSHADER_FIRE_FIRE	{ ACCEPT{fx_channel_fire;} }
			BUTTON  GASSHADER_FIRE_FIRE_SELECTOR {SCALE_V; FIT_H;}

			LINK GASSHADER_FIRE_FLUID	{ ACCEPT{fx_fluid;} }
			BUTTON  GASSHADER_FIRE_FLUID_SELECTOR {SCALE_V; FIT_H;}

			REAL GASSHADER_FIRE_ADVECTION	{ MIN 0.0; MAXSLIDER 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
		}
		REAL GASSHADER_FIRE_AFFECTGI	{ MIN 0; MAX 10000; UNIT PERCENT; }
		LONG GASSHADER_FIRE_VISIBILITY  
		{  
			CYCLE
			{
				GASSHADER_FIRE_VISIBILITY_TEMPERATURE;
				GASSHADER_FIRE_VISIBILITY_FIRE;
			}
		}
		REAL GASSHADER_SMOKE_FIRESOOT {MIN 0; MAX 1.0; STEP 0.01; }

		GROUP GASSHADER_FIRE_COLOR_SUB
		{
			DEFAULT 1;		
			REAL GASSHADER_FIRE_RADIATION  {MIN 0; MAX 10000; STEP 0.1; }	
			REAL GASSHADER_FIRE_RADIATION_ABSORPTION {MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER; }	
			LONG GASSHADER_FIRE_COLOR_TYPE
			{
				CYCLE
				{
					GASSHADER_FIRE_COLOR_TYPE_BLACKBODY;
					GASSHADER_FIRE_COLOR_TYPE_ARTISTIC;
				}
			}

			BITMAPBUTTON GASSHADER_FIRE_COLOR_BLACKBODYPREVIEW {BORDER; FIT_H;} //Show physical gradient
			GRADIENT GASSHADER_FIRE_COLOR_CUSTOM {COLOR; ANIM ON; ICC_BASEDOCUMENT;}

			LONG GASSHADER_FIRE_COLOR_BLACKBODY_TONE 
			{
				CYCLE
				{
					GASSHADER_FIRE_COLOR_BLACKBODY_TONE_NTSC;
					GASSHADER_FIRE_COLOR_BLACKBODY_TONE_PAL;
					GASSHADER_FIRE_COLOR_BLACKBODY_TONE_SMPTE;
					GASSHADER_FIRE_COLOR_BLACKBODY_TONE_HDTV;
					GASSHADER_FIRE_COLOR_BLACKBODY_TONE_CIE;
					GASSHADER_FIRE_COLOR_BLACKBODY_TONE_CIEREC709;
				}
			}
			VECTOR GASSHADER_FIRE_COLOR_BLACKBODY_BOOST {MIN 0.001 0.001 0.001; MAX 100 100 100; STEP 0.01;}
			REAL GASSHADER_FIRE_COLOR_BLACKBODY_INTENSITY {MIN 1; MAX 10; STEP 0.01; }
			REAL GASSHADER_FIRE_COLOR_BLACKBODY_TSCALE {MIN 0; MAX 100; STEP 0.1; CUSTOMGUI REALSLIDER;}
			BOOL GASSHADER_FIRE_COLOR_BLACKBODY_GAMMA {}
			BOOL GASSHADER_FIRE_COLOR_BLACKBODY_NORMALIZE {}
			
		}
		GROUP GASSHADER_FIRE_RADIATION_SUB //MAP
			{	
				REAL GASSHADER_FIRE_RADIATION_POWER  {MIN 0; MAX 10000; STEP 0.1; }
				LONG GASSHADER_FIRE_RADIATION_ALGORITHM
				{
					CYCLE
					{
						GASSHADER_FIRE_RADIATION_ALGORITHM_SPREADMAP;
						GASSHADER_FIRE_RADIATION_ALGORITHM_SCATTERMAP;
					}
				}
				REAL GASSHADER_FIRE_RADIATION_VOXELSCALE { MIN 0.1; STEP 0.1; MAX 1.0;}		
				GRADIENT GASSHADER_FIRE_RADIATION_REMAP {ALPHA; ANIM ON;}

				SEPARATOR {LINE;}

				LONG GASSHADER_FIRE_RADIATION_COLOR_TYPE
				{
					CYCLE
					{
						GASSHADER_FIRE_RADIATION_COLOR_TYPE_PHYSICAL;
						GASSHADER_FIRE_RADIATION_COLOR_TYPE_CUSTOM;
					}
				}
				GRADIENT GASSHADER_FIRE_RADIATION_COLOR {COLOR; ANIM ON;ICC_BASEDOCUMENT;}							
				REAL GASSHADER_FIRE_RADIATION_RADIUS {MIN 0.01; UNIT METER;}
				REAL GASSHADER_FIRE_RADIATION_TSCALE {MIN 1; MAX 100; STEP 0.01; }
				
				SEPARATOR {LINE;}

				BOOL GASSHADER_FIRE_RADIATION_USEPHASE {}
			}
		GROUP GASSHADER_FIRE_DENSITY_TEMP_SUB
		{
			DEFAULT 1;	
			REAL	GASSHADER_FIRE_DENSITY_TEMP_THRESHOLD {MIN 297.5; MAX 5000; STEP 1;}		
			GRADIENT GASSHADER_FIRE_DENSITY_TEMP_MAPPING {ALPHA; ANIM ON;}	 
			IN_EXCLUDE GASSHADER_FIRE_DENSITY_TEMP_CONSTRAINTS
			{
				NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 0;
				ACCEPT {  fx_constraint_coffee; fx_constraint_particledistance; fx_constraint_particlecount;fx_constraint_volume; fx_constraint_noise; fx_constraint_gradient; fx_constraint_gridvalue; fx_constraint_gridaverage; fx_constraint_voxeldistance; fx_constraint_particle_collision;fx_constraint_particle_property;};
			}

			SEPARATOR {LINE;}
			
			GROUP { COLUMNS 2;
			LONG  GASSHADER_FIRE_DENSITY_TEMP_BLURITER {MIN 0; MAX 100;}
			REAL  GASSHADER_FIRE_DENSITY_TEMP_BLUR {MIN 0; MAX 1000;}
			}
		}
		GROUP GASSHADER_FIRE_DENSITY_FIRE_SUB
		{
			DEFAULT 1;			
			REAL		GASSHADER_FIRE_DENSITY_FIRE_THRESHOLD {MIN 0; MAX 0.999; STEP 0.001;}		
			GRADIENT	GASSHADER_FIRE_DENSITY_FIRE_MAPPING {ALPHA; ANIM ON;} 
			IN_EXCLUDE	GASSHADER_FIRE_DENSITY_FIRE_CONSTRAINTS
			{
				NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 0;
				ACCEPT {  fx_constraint_coffee; fx_constraint_particledistance; fx_constraint_particlecount;fx_constraint_volume; fx_constraint_noise; fx_constraint_gradient; fx_constraint_gridvalue; fx_constraint_gridaverage; fx_constraint_voxeldistance; fx_constraint_particle_collision;fx_constraint_particle_property;};
			}

			SEPARATOR {LINE;}
			
			GROUP { COLUMNS 2;
			LONG  GASSHADER_FIRE_DENSITY_FIRE_BLURITER {MIN 0; MAX 100;}
			REAL  GASSHADER_FIRE_DENSITY_FIRE_BLUR {MIN 0; MAX 1000;}	
			}
		}
	}
	GROUP GASSHADER_COMPOSITE_G
	{		
		REAL	 GASSHADER_COMPOSITE_LUMINANCE {MIN 0; MAX 1000; MINSLIDER 0; MAXSLIDER 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
		GRADIENT GASSHADER_COMPOSITE_LUMINANCE_GRADIENT {COLOR; ANIM ON;ICC_BASEDOCUMENT;}

		SEPARATOR {LINE;}
		
		REAL	GASSHADER_COMPOSITE_BRIGHTNESS {MIN 0; MAX 1000; MINSLIDER 0; MAXSLIDER 200; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
		REAL	GASSHADER_COMPOSITE_CONTRAST {MIN -100; MAX 100000; MINSLIDER -100; MAXSLIDER 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
		REAL	GASSHADER_COMPOSITE_SATURATION {MIN 0; MAX 100000; MINSLIDER 0; MAXSLIDER 200; UNIT PERCENT; CUSTOMGUI REALSLIDER;}

		GROUP GASSHADER_COMPOSITE_MULTIPASS_SUB
		{
			HIDDEN;
			COLUMNS 2;
			BOOL GASSHADER_COMPOSITE_MP_DIFFUSE {}
			BOOL GASSHADER_COMPOSITE_MP_LUMINANCE {}
			BOOL GASSHADER_COMPOSITE_MP_ALPHA {}
			BOOL GASSHADER_COMPOSITE_MP_DEPTH {}
			BOOL GASSHADER_COMPOSITE_MP_SHADOWS {}
			BOOL GASSHADER_COMPOSITE_MP_SMOKE {}
			BOOL GASSHADER_COMPOSITE_MP_FIRE {}
			BOOL GASSHADER_COMPOSITE_MP_MOTION {}
			BOOL GASSHADER_COMPOSITE_MP_MS {}
			BOOL GASSHADER_COMPOSITE_MP_HEAT {}
			BOOL GASSHADER_COMPOSITE_MP_FIRELIGHT {}
			BOOL GASSHADER_COMPOSITE_MP_SCATTERDEPTH {}
		}
	}
}
